--[[---------------------------------------------------------------------------
	Chocolatier Two High Score Submission dialog
	Copyright (c) 2006-2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

local xLeft = kCenter-ui.devButtonW/2
local xRight = kCenter+ui.devButtonW/2
local EditFieldColor = PopupColor

local label = "submit_score"
if gDialogTable.medalsOnly then label = "submit_medals" end

-------------------------------------------------------------------------------

local s = GetSubmitInfo()
if s then
	local f = loadstring(s)
	if f then f() end
end

local anonymous = bsgCheckConfig("anonymous")
local name = gDialogTable.name or gName or ""
local username = gDialogTable.username or gUsername or ""
local password = gDialogTable.password or gPassword or ""
local remember = gDialogTable.remember or gRemember or false
local score = gDialogTable.score or gScore or 0

gName = nil
gUsername = nil
gPassword = nil
gRemember = nil
gScore = nil

-------------------------------------------------------------------------------

local function DoSubmit()
	name = GetLabel("name")
	username = GetLabel("username")
	password = GetLabel("password")
	remember = GetButtonToggleState("remember")

	if anonymous then
		SubmitScore(name,"","",false)
	else
--		if username == nil or username == "" or password == nil or password == "" then
--			DisplayDialog { "ui/okdialog.lua", body="accountinforequired" }
--		elseif gDialogTable.medalsOnly then
		if gDialogTable.medalsOnly then
			if username == nil or username == "" or password == nil or password == "" then
				DisplayDialog { "ui/okdialog.lua", body="accountinforequired" }
			else
				SubmitMedals(gSim:GetMedalFlags(),name,username,password,remember)
			end
		else
		--,gSim:GetMedalFlags()
			SubmitScore(name,username,password,remember)
		end
	end
	
	CloseWindow()
end

-------------------------------------------------------------------------------

local instructions = "pfaccountlabel"
local privacypolicy = "privacypolicy"
if anonymous then
	instructions = "anonaccountlabel"
	privacypolicy = "anonymous_privacypolicy"
end

MakeDialog
{
	Frame
	{
		x=kCenter,y=kCenter,w=ui.screenWidth/2,h=240,color=DialogColor,

		TextButton { x=xLeft,y=160, name="submit", label=label, command=DoSubmit },
		TextButton { x=xRight,y=160, name="close", close=true, label="close", },
		
		AppendStyle { flags=kVAlignCenter+kHAlignLeft },
		
		Text { name="instructions", x=0,y=5,w=kMax,h=40, label=instructions, flags=kVAlignTop+kHAlignCenter },
		
		Text { name="namelabel", x=10,y=30,w=145,h=20, label="namelabel", flags=kVAlignCenter+kHAlignRight },
		Rectangle { name="nameentry", x=165,y=30,w=215,h=20, color=EditFieldColor,
			TextEdit { name="name", x=0,y=0,w=kMax,h=kMax, length=12, label=name },
		},
		
		Text { name="usernamelabel", x=10,y=70,w=145,h=20, label="usernamelabel", flags=kVAlignCenter+kHAlignRight },
		Rectangle { name="usernameentry", x=165,y=70,w=215,h=20, color=EditFieldColor,
			TextEdit { name="username", x=0,y=0,w=kMax,h=kMax, length=26, label=username },
		},

		Text { name="passwordlabel", x=10,y=100,w=145,h=20, label="passwordlabel", flags=kVAlignCenter+kHAlignRight },
		Rectangle { name="passwordentry", x=165,y=100,w=215,h=20, color=EditFieldColor,
			TextEdit { name="password", x=0,y=0,w=kMax,h=kMax, length=26, label=password, password = true, },
		},
		
--		TextButton { x=70,y=130, name="remember", type=kToggle, scale=20/ui.devButtonH },
--		Text { x=165,y=130,w=215,h=20, name="rememberlabel", label="rememberlabel", font={ standardFontName, kSixteen, DefaultColor }, },
		Button { x=130,y=120, scale=.5, type=kToggle, name="remember", graphics=CheckButtonGraphics, },
		Text { x=130+30,y=125,w=200,h=32, name="rememberlabel", label="rememberlabel", flags=kVAlignCenter+kHAlignLeft, font={ standardFontName, kSixteen, DefaultColor } },

		Text { x=40,y=200,w=kMax-40,h=40, label=privacypolicy },
		Button { name="privacy", graphics={}, command=PrivacyPolicy, },
	}
}

--EnableWindow("nameentry", anonymous)
--EnableWindow("namelabel", anonymous)
EnableWindow("usernameentry", not anonymous)
EnableWindow("usernamelabel", not anonymous)
EnableWindow("passwordentry", not anonymous)
EnableWindow("passwordlabel", not anonymous)
EnableWindow("remember", not anonymous)
EnableWindow("rememberlabel", not anonymous)
SetButtonToggleState("remember",remember)

if gDialogTable.medalsOnly then
	EnableWindow("nameentry", false)
	EnableWindow("namelabel", false)
end
